#pragma once

#include "plain.h"

namespace NRTYDeploy {

    class TRtyDiffFileContentGenerator : public TFileContentGenerator {
    public:
        TRtyDiffFileContentGenerator();
        TRtyDiffFileContentGenerator(const TFsPath& path, const TString& def, const TString& rename, const TString& prefix, const ICommonData& data, const TString& ctype, const TString& service, i64 version = -1);
        virtual TString GetType() const override;
        virtual TString GetRename(const TContext& context) const override;
        virtual bool GetContent(TString& result, const ICommonData& common, const TContext& context) const override;
        virtual void Serialize(NJson::TJsonValue& json) const override;
        virtual void SetLastVersion() override;

        static TFactory::TRegistrator<TRtyDiffFileContentGenerator> Registrar;

    protected:
        virtual void DoDeserialize(const NJson::TJsonValue& json) override;
        TString Patch(const TString& original, const TString& patch) const;

    private:
        void ApplyToDefault(TString& result, const ICommonData& common, const TContext& context) const;
        void ApplyCTypeDiff(TString& result, const ICommonData& common, const TContext& context) const;
        void PatchDocFetcher(TString& result, const ICommonData& common, const TContext& context) const;
        void PatchQueryLanguage(TString& result, const ICommonData& common, const TContext& context) const;

    private:
        TPtr Diff;
        TPtr QueryLanguage;
        TPtr CTypeDiff;
        TPtr DefaultConfig;
        TString Rename;
        TString Prefix;
        mutable i64 ClusterMetaVersion;
    };

}
