#include "rty_diff.h"

#include <library/cpp/testing/unittest/registar.h>

using namespace NRTYDeploy;


Y_UNIT_TEST_SUITE(TRTYDiffConfigPatch) {

    class TTestTRtyDiffFileContentGenerator : public TRtyDiffFileContentGenerator {
    public:
        TString Patch(const TString& original, const TString& patch) const {
            return TRtyDiffFileContentGenerator::Patch(original, patch);
        }
    };

    const TString config = "<DaemonConfig>\n"
        "   <Controller>\n"
        "       ClientTimeout : 200\n"
        "       ConfigsControl : true\n"
        "       ConfigsRoot : ${WorkDir and WorkDir or _BIN_DIRECTORY}/configs\n"
        "       Host : 127.0.0.1\n"
        "       Port : 1234\n"
        "   </Controller>\n"
        "</DaemonConfig>\n"
        "<Server>\n"
        "   <BaseSearchersServer>\n"
        "       ClientTimeout : 200\n"
        "       Host : 127.0.0.1\n"
        "       MaxConnections : 0\n"
        "       MaxQueue : 5000\n"
        "       Port : 1235\n"
        "       Threads : 64\n"
        "   </BaseSearchersServer>\n"
        "</Server>\n";

    Y_UNIT_TEST(TestPlainConfigPatch) {
        TTestTRtyDiffFileContentGenerator gen;
        const TString patch = "{"
        "\"BaseSearchersServer.Host\": \"__remove__\""
        "}";
        const TString patched = gen.Patch(config, patch);
        TAnyYandexConfig yandexConfig;
        if (!yandexConfig.ParseMemory(patched.data())) {
            TString errorMessage;
            yandexConfig.PrintErrors(errorMessage);
            UNIT_FAIL(errorMessage);
        }

        TYandexConfig::Section* serverSection = yandexConfig.GetFirstChild("Server");
        UNIT_ASSERT_UNEQUAL(serverSection, nullptr);
        TYandexConfig::TSectionsMap sections = serverSection->GetAllChildren();
        TYandexConfig::TSectionsMap::const_iterator iter = sections.find("BaseSearchersServer");
        UNIT_ASSERT_UNEQUAL(iter, sections.end());
        const TYandexConfig::Directives& directives = iter->second->GetDirectives();

        const ui32 port =  directives.Value("Port", 0);
        UNIT_ASSERT_EQUAL(port, 1235);
        const TString host =  directives.Value("Host", Default<TString>());
        UNIT_ASSERT_EQUAL(host, Default<TString>());
    }

    Y_UNIT_TEST(TestCustomPrefixPatch) {
        TTestTRtyDiffFileContentGenerator gen;
        const TString patch = "{"
        "\"BaseSearchersServer.Host\": \"__remove__\","
        "\"DaemonConfig\": {"
        "\"Controller.Host\": \"__remove__\""
        "}"
        "}";
        const TString patched = gen.Patch(config, patch);
        TAnyYandexConfig yandexConfig;
        if (!yandexConfig.ParseMemory(patched.data())) {
            TString errorMessage;
            yandexConfig.PrintErrors(errorMessage);
            UNIT_FAIL(errorMessage);
        }

        TYandexConfig::Section* serverSection = yandexConfig.GetFirstChild("Server");
        UNIT_ASSERT_UNEQUAL(serverSection, nullptr);
        TYandexConfig::TSectionsMap sections = serverSection->GetAllChildren();
        TYandexConfig::TSectionsMap::const_iterator iter = sections.find("BaseSearchersServer");
        UNIT_ASSERT_UNEQUAL(iter, sections.end());
        const TYandexConfig::Directives& directives = iter->second->GetDirectives();

        const ui32 port =  directives.Value("Port", 0);
        UNIT_ASSERT_EQUAL(port, 1235);
        const TString host =  directives.Value("Host", Default<TString>());
        UNIT_ASSERT_EQUAL(host, Default<TString>());

        TYandexConfig::Section* daemonSection = yandexConfig.GetFirstChild("DaemonConfig");
        UNIT_ASSERT_UNEQUAL(daemonSection, nullptr);
        TYandexConfig::TSectionsMap daemonSections = daemonSection->GetAllChildren();
        TYandexConfig::TSectionsMap::const_iterator daemonIter = daemonSections.find("Controller");
        UNIT_ASSERT_UNEQUAL(daemonIter, daemonSections.end());
        const TYandexConfig::Directives& daemonDirectives = daemonIter->second->GetDirectives();

        const ui32 daemonPort =  daemonDirectives.Value("Port", 0);
        UNIT_ASSERT_EQUAL(daemonPort, 1234);
        const TString daemonHost =  daemonDirectives.Value("Host", Default<TString>());
        UNIT_ASSERT_EQUAL(daemonHost, Default<TString>());
    }
}

