#pragma once

#include "cached.h"

namespace NRTYDeploy {

    class TSearchMapContentGenerator : public TCachedFileContentGenerator {
        mutable i64 Version;
        TString ServiceType;
    public:
        TSearchMapContentGenerator();
        TSearchMapContentGenerator(const ICommonData& data, const TString& ctype, const TString& serviceType, i64 version = -1);
        TString GetType() const override;
        virtual TString GetRename(const TContext& context) const override;
        virtual void Serialize(NJson::TJsonValue& json) const override;
        virtual void DoDeserialize(const NJson::TJsonValue& json) override;
        virtual void SetLastVersion() override;

        static TFactory::TRegistrator<TSearchMapContentGenerator> Registrator;

    protected:
        virtual bool DoGetContent(TString& result, const ICommonData& common, const TContext& context) const override;
        virtual TString GetCacheKey(const TContext& context) const override;
    };
}
