#pragma once

#include "common.h"
#include <util/folder/path.h>

namespace NRTYDeploy {

    class TSlaDescriptionFileContentGenerator : public TFileContentGenerator {
    public:
        TSlaDescriptionFileContentGenerator() {
        }

        TSlaDescriptionFileContentGenerator(const TFsPath& path, const ICommonData& common, const TString& service, i64 version = -1)
            : Path(path)
            , Service(service)
            , Version(version)
        {
            Path.Fix();
            if (Version == -1) {
                common.GetStorage().GetVersion(GetSrcFilePath(Path).GetPath(), Version);
            }
        }

        static TFsPath GetSrcFilePath(const TFsPath& generatedPath) {
            return generatedPath.Parent() / "sla_description.conf";
        }

        static TString GetRename(const TString& service) {
            return "sla_description-" + service + ".conf";
        }

        virtual TString GetType() const override;
        virtual TString GetRename(const TContext& context) const override;
        virtual bool GetContent(TString& result, const ICommonData& common, const TContext& context) const override;

        virtual void DoDeserialize(const NJson::TJsonValue& json) override;

        static TFactory::TRegistrator<TSlaDescriptionFileContentGenerator> Registrar;

        void Serialize(NJson::TJsonValue& json) const override;

    private:
        void ProduceContent(IOutputStream& out, const ICommonData& common, const TContext& context) const;

    private:
        TFsPath Path;
        TString Service;
        i64 Version = -1;
    };

}
