#include "get_slots_used_free.h"

#include <saas/deploy_manager/modules/resources/resources.h>
#include <saas/deploy_manager/scripts/common/deploy/deploy_builder.h>

namespace NRTYDeploy {
    bool GetUsingServiceSlots(const TString& ctype, const TString& serviceType, const TString& serviceName, IDeployInfoRequest& request, TVector<NSearchMapParser::TSearchMapHost>& result) {
        request.GetResourcesManager().GetCluster(serviceType, serviceName);
        NRTYDeployInfo::IDeployComponentInfo::TPtr componentInfo = NRTYDeployInfo::IDeployComponentInfo::TFactory::Construct(serviceType);
        if (!componentInfo)
            return false;
        componentInfo->SetInfo(&request.GetCommonData(), ctype);
        NSearchMapParser::TSearchMap sm = componentInfo->SearchMap(serviceName);
        auto&& slotsSM = sm.GetSlots();

        result.clear();
        for (auto&& i : slotsSM) {
            result.push_back(i);
        }
        return true;
    }

    bool GetFreeSlotsForService(const TString& ctype, const TString& serviceType, const TString& serviceName, IDeployInfoRequest& request, NRTYCluster::TCluster& result) {
        NRTYDeployInfo::IDeployComponentInfo::TPtr componentInfo = NRTYDeployInfo::IDeployComponentInfo::TFactory::Construct(serviceType);
        if (!componentInfo)
            return false;
        componentInfo->SetInfo(&request.GetCommonData(), ctype);
        NSearchMapParser::TSearchMap sm = componentInfo->SearchMap(serviceName);
        return request.GetResourcesManager().GetFreeSlotsForService(ctype, serviceType, serviceName, sm, result);
    }
}
