#pragma once

#include <saas/deploy_manager/storage/abstract.h>
#include <library/cpp/json/writer/json_value.h>
#include <util/generic/map.h>

namespace NRTYDeploy {

    class TRelevWorkHelper {
    public:
        typedef TMap<ui32, TString> TNameByIndex;
        typedef TMap<TString, ui32> TIndexByName;
    public:
        const TNameByIndex& GetNameByIndex() const {
            return NameByIndex;
        }

        const TIndexByName& GetIndexByName() const {
            return IndexByName;
        }

        void LoadFactors(ICommonData& commonData, const TString& service, const TString& ctype);
    private:
        TNameByIndex NameByIndex;
        TIndexByName IndexByName;
        void LoadFactors(const TString& config);
        void LoadFactors(const NJson::TJsonValue& factorsSet);
        TString LoadRelveConfig(ICommonData& commonData, const TFsPath& path);
    };

};
