#pragma once

#include <library/cpp/object_factory/object_factory.h>
#include <saas/deploy_manager/storage/abstract.h>
#include <saas/deploy_manager/scripts/cluster/cluster_task.h>

class IDeployInfoRequest;

namespace NRTYDeploy {

    class IScript {
    private:
        TString OldData;
        TString NewData;
        TString AdditionalMessage;
    public:
        typedef NObjectFactory::TObjectFactory<IScript, TString> TFactory;

    public:
        virtual ~IScript() {}

        virtual bool Process(IDeployInfoRequest& request) = 0;
        virtual TString Help() { return ""; }
        virtual bool CommandPermitted(IDeployInfoRequest& request);
        const TString& GetAdditionalMessage() const {
            return AdditionalMessage;
        }

        const TString& GetOldData() const {
            return OldData;
        }

        const TString& GetNewData() const {
            return NewData;
        }

    protected:
        virtual void FillUsedResources(IUserAccessControl::TUsedResources& result, IDeployInfoRequest& request);
        void SetAdditionalMessage(const TString& additionalMessage) {
            AdditionalMessage = additionalMessage;
        }

        void SetData(const TString& oldData, const TString& newData) {
            if (!!oldData)
                OldData = oldData;
            if (!!newData)
                NewData = newData;
        }

    };
    class IScriptWithTask: public IScript {
    protected:
        virtual TClusterTask::TPtr DoBuildTask(IDeployInfoRequest& request) const = 0;
    public:
        virtual bool Process(IDeployInfoRequest& request) override final;
    };
}
