#pragma once

#include <saas/deploy_manager/scripts/common/file_content_generators/common.h>
#include <library/cpp/json/json_value.h>

namespace NRTYDeploy {

    class TNodesStructure : public TVector<TFileContentGenerator::TPtr> {
    public:
        TString Serialize() const;
        NJson::TJsonValue SerializeWithContext(const TFileContentGenerator::TContext& context) const;
        bool Deserialize(const TString& json, i64* version = nullptr);
        void UpdateTimestamp() {
            Timestamp = Now();
        }
        const TInstant& GetTimestamp() const {
            return Timestamp;
        }

        void UpdateByRename(TFileContentGenerator::TPtr info, const TFileContentGenerator::TContext& context) {
            for (ui32 i = 0; i < size(); ++i) {
                if (at(i)->GetRename(context) == info->GetRename(context)) {
                    at(i) = info;
                    return;
                }
            }
            push_back(info);
        }

    private:
        TInstant Timestamp;
        static const i64 SerializingVersion = 1;
    };
}

