#pragma once

#include <saas/deploy_manager/protos/sla_description.pb.h>
#include <saas/library/storage/abstract.h>

#include <library/cpp/json/json_reader.h>

#include <util/generic/string.h>

namespace NRTYDeploy {

    struct SLAUpdateStatus {
        i64 Version = -1;
        TString OldDataProto;
        TString NewDataProto;
    };

    const TString& GetSLATimestampPath();

    bool TryGetSLADescription(const TString& serviceName, const NSaas::IVersionedStorage& storage, NSaasProto::TSlaDescription& description);
    bool TryGetSLADefault(const TString& ctype, const NSaas::IVersionedStorage& storage, NSaasProto::TSlaDescription& description);
    void MergeSLA(const NSaasProto::TSlaDescription& defaultDescr, NSaasProto::TSlaDescription& serviceDescr);
    SLAUpdateStatus StoreSLADescription(const TString& serviceName, NSaas::IVersionedStorage& storage, NSaasProto::TSlaDescription& description);

    NJson::TJsonValue SerializeDescription(const NSaasProto::TSlaDescription& description, const TString& ctype);
    void PatchDescription(NSaasProto::TSlaDescription& description, const NJson::TJsonValue& value, const TString& ctype);
}

