#include "sla_processing.h"

#include <library/cpp/testing/unittest/registar.h>

using namespace NRTYDeploy;


Y_UNIT_TEST_SUITE(TRtySLAProcessing) {

    Y_UNIT_TEST(TestSerialization) {
        NSaasProto::TSlaDescription description;
        description.AddOwnerLogin("owner-login1");
        description.AddOwnerLogin("owner-login2");
        description.AddResponsibles("resp-login1");
        description.AddResponsibles("resp-login2");

        NSaasProto::TCtypeSLA* stable = description.AddCTypeSLA();
        stable->SetCtype("stable");
        stable->SetUnanswers5MinPercWarn(0.05);
        stable->SetUnanswers5MinPercCrit(1.0);
        stable->SetServiceWeight(1);
        stable->SetABCUserService(644);
        stable->AddNannyFerryman("saas_fm_myservice_arnold");
        stable->AddNannyFerryman("saas_fm_myservice_hahn");

        NSaasProto::TCtypeSLA* prestable = description.AddCTypeSLA();
        prestable->SetCtype("prestable");
        prestable->SetServiceWeight(0);

        NJson::TJsonValue stableJson = SerializeDescription(description, "stable");
        UNIT_ASSERT_EQUAL(stableJson["owners"].GetArray().size(), 2);
        UNIT_ASSERT_EQUAL(stableJson["owners"][0].GetString(), "owner-login1");
        UNIT_ASSERT_EQUAL(stableJson["owners"][1].GetString(), "owner-login2");
        UNIT_ASSERT_EQUAL(stableJson["responsibles"].GetArray().size(), 2);
        UNIT_ASSERT_EQUAL(stableJson["responsibles"][0].GetString(), "resp-login1");
        UNIT_ASSERT_EQUAL(stableJson["responsibles"][1].GetString(), "resp-login2");
        UNIT_ASSERT_EQUAL(stableJson["service_weight"].GetUInteger(), 1);
        UNIT_ASSERT_EQUAL(stableJson["abc_user_service"].GetUInteger(), 644);
        UNIT_ASSERT_DOUBLES_EQUAL(stableJson["unanswers_5min_perc_warn"].GetDouble(), 0.05, 1e-16);
        UNIT_ASSERT_DOUBLES_EQUAL(stableJson["unanswers_5min_perc_crit"].GetDouble(), 1.0, 1e-16);
        UNIT_ASSERT_EQUAL(stableJson["ferrymans"].GetArray().size(), 2);
        UNIT_ASSERT_EQUAL(stableJson["ferrymans"][0].GetString(), "saas_fm_myservice_arnold");
        UNIT_ASSERT_EQUAL(stableJson["ferrymans"][1].GetString(), "saas_fm_myservice_hahn");

        NJson::TJsonValue prestableJson = SerializeDescription(description, "prestable");
        UNIT_ASSERT_EQUAL(prestableJson["owners"].GetArray().size(), 2);
        UNIT_ASSERT_EQUAL(prestableJson["owners"][0].GetString(), "owner-login1");
        UNIT_ASSERT_EQUAL(prestableJson["owners"][1].GetString(), "owner-login2");
        UNIT_ASSERT_EQUAL(prestableJson["responsibles"].GetArray().size(), 2);
        UNIT_ASSERT_EQUAL(prestableJson["responsibles"][0].GetString(), "resp-login1");
        UNIT_ASSERT_EQUAL(prestableJson["responsibles"][1].GetString(), "resp-login2");
        UNIT_ASSERT(!prestableJson.Has("unanswers_5min_perc_warn"));
        UNIT_ASSERT(!prestableJson.Has("unanswers_5min_perc_crit"));
    }

    Y_UNIT_TEST(TestPatch) {
        NSaasProto::TSlaDescription description;
        description.AddOwnerLogin("owner-login1");
        description.AddOwnerLogin("owner-login2");
        description.AddResponsibles("resp-login1");
        description.AddResponsibles("resp-login2");

        NSaasProto::TCtypeSLA* prestable = description.AddCTypeSLA();
        prestable->SetCtype("prestable");
        prestable->SetServiceWeight(0);

        NSaasProto::TSlaDescription description2 = description;
        NSaasProto::TCtypeSLA* stable = description2.AddCTypeSLA();
        stable->SetCtype("stable");
        stable->SetUnanswers5MinPercWarn(0.05);
        stable->SetUnanswers5MinPercCrit(1.0);
        stable->SetServiceWeight(1);
        stable->AddNannyFerryman("saas_fm_myservice_arnold");
        stable->AddNannyFerryman("saas_fm_myservice_hahn");

        NJson::TJsonValue stableJson;
        stableJson["service_weight"] = 1;
        stableJson["unanswers_5min_perc_warn"] = 0.05;
        stableJson["unanswers_5min_perc_crit"] = 1.0;
        stableJson["ferrymans"] = NJson::JSON_ARRAY;
        stableJson["ferrymans"].AppendValue("saas_fm_myservice_arnold");
        stableJson["ferrymans"].AppendValue("saas_fm_myservice_hahn");

        PatchDescription(description, stableJson, "stable");
        UNIT_ASSERT_EQUAL(description.DebugString(), description2.DebugString());

    }

}


