#include "action.h"

#include <library/cpp/json/json_reader.h>

namespace NDaemonController {

    NJson::TJsonValue TCopyServiceAction::DoSerializeToJson() const {
        NJson::TJsonValue result;
        result.InsertValue("from", SourceServiceName);
        result.InsertValue("to", DestServiceName);
        return result;
    }

    void TCopyServiceAction::DoDeserializeFromJson(const NJson::TJsonValue& json) {
        SourceServiceName = json["from"].GetStringRobust();
        DestServiceName = json["to"].GetStringRobust();
    }

    void TCopyServiceAction::DoInterpretResult(const TString& result) {
        Success(result);
    }

    TCopyServiceAction::TFactory::TRegistrator<TCopyServiceAction> TCopyServiceAction::Registrator(COPY_SERVICE_ACTION_NAME);
}
