#pragma once
#include <saas/library/daemon_base/actions_engine/controller_client.h>
#include <util/generic/vector.h>

#define COPY_SERVICE_ACTION_NAME "COPY_SERVICE"

namespace NDaemonController {

    class TCopyServiceAction: public TAction {
    public:

        TCopyServiceAction()
        {}

        TCopyServiceAction(const TString& sourceServiceName, const TString& destServiceName)
            : SourceServiceName(sourceServiceName)
            , DestServiceName(destServiceName)
        {}

        virtual TString GetCustomUri() const override {
            return "copy_service";
        }

        virtual TString DoBuildCommand() const override {
            return "from=" + SourceServiceName + "&to=" + DestServiceName;
        }
        virtual void DoInterpretResult(const TString& result) override;
        virtual TString ActionName() const override { return COPY_SERVICE_ACTION_NAME; }

    protected:
        virtual NJson::TJsonValue DoSerializeToJson() const override ;
        virtual void DoDeserializeFromJson(const NJson::TJsonValue& json) override ;

        static TFactory::TRegistrator<TCopyServiceAction> Registrator;

    private:
        TString SourceServiceName;
        TString DestServiceName;
    };
}
