#include "action.h"

#include <library/cpp/json/writer/json_value.h>

namespace NRTYDeploy {
    NJson::TJsonValue TActionSetDatabaseVersion::DoSerializeToJson() const {
        NJson::TJsonValue result;
        result["service"] = Service;
        result["ctype"] = CType;
        result["version"] = Version;
        return result;
    }

    void TActionSetDatabaseVersion::DoDeserializeFromJson(const NJson::TJsonValue& json) {
        Service = json["service"].GetString();
        CType = json["ctype"].GetString();
        Version = json["version"].GetUIntegerRobust();
    }

    TActionSetDatabaseVersion::TFactory::TRegistrator<TActionSetDatabaseVersion> TActionSetDatabaseVersion::Registrator("set_database_version");
}
