#pragma once

#include <saas/library/daemon_base/actions_engine/list_conf/action.h>

namespace NRTYDeploy {

    class TActionSetDatabaseVersion : public NDaemonController::TAction {
    private:
        TString Service;
        TString CType;
        ui32 Version = 0;

    protected:
        virtual NJson::TJsonValue DoSerializeToJson() const override;
        virtual void DoDeserializeFromJson(const NJson::TJsonValue& json) override;

        static TFactory::TRegistrator<TActionSetDatabaseVersion> Registrator;
    public:
        TActionSetDatabaseVersion() {}
        TActionSetDatabaseVersion(const TString& service, const TString& ctype, ui32 version)
            : Service(service)
            , CType(ctype)
            , Version(version)
        {}

        virtual TString GetCustomUri() const override {
            return "set_database_version";
        }
        virtual TString DoBuildCommand() const override {
            return "service=" + Service + "&ctype=" + CType + "&version=" + ToString(Version);
        }
        virtual void DoInterpretResult(const TString& result) override {
            Version = FromString<ui32>(result);
            Success("");
        }

        virtual TString ActionName() const override {
            return "set_database_version";
        }
    };
}
