#include "script.h"

#include <saas/deploy_manager/scripts/common/scripts_helper.h>
#include <saas/deploy_manager/server/client/client.h>

namespace NRTYDeploy {
    bool TScriptSetDatabaseVersion::Process(IDeployInfoRequest& request) {
        const TCgiParameters& cgi = request.GetRD().CgiParam;
        TString Path;
        if (!Path) {
            Path = cgi.Get("path");
        }
        if (!Path) {
            const TString& service = cgi.Get("service");
            const TString& ctype = cgi.Get("ctype");
            const TString& root = cgi.Has("root") ? cgi.Get("root") : "rty";
            Y_ENSURE(service, "Service must be specified");
            Y_ENSURE(ctype, "CType must be specified");
            Y_ENSURE(root, "Root cannot be empty");
            Path = root + "/" + ctype + "/" + service + "/base_version";
        }
        Y_ENSURE(Path, "Path is empty");

        const ui32 version = FromString<ui32>(cgi.Get("version"));
        Y_ENSURE(version, "Cannot set zero version");
        Y_ENSURE(request.GetStorage().SetValue(Path, ToString(version)), "Cannot set value in storage");

        request.Output() << "HTTP/1.1 200 \r\n\r\n";
        request.Output() << version;
        return true;
    };

    IScript::TFactory::TRegistrator<TScriptSetDatabaseVersion> TScriptSetDatabaseVersion::Registrator("set_database_version");
}
