#include "action.h"

#include <saas/library/searchmap/slots_pool.h>
#include <library/cpp/json/writer/json_value.h>
#include <library/cpp/json/json_reader.h>
#include <library/cpp/logger/global/global.h>

namespace NRTYDeploy {

    NJson::TJsonValue TDeployAction::DoSerializeToJson() const {
        NJson::TJsonValue result;
        result.InsertValue("service", Service);
        result.InsertValue("ctype", CType);
        result.InsertValue("version", Version);
        result.InsertValue("may_be_dead_percentage", MayBeDeadInIntervalPercentage);
        result.InsertValue("force_services", ForceServices);
        result.InsertValue("diff_slots_only", DiffSlotsOnly);
        result.InsertValue("service_type", ServiceType);
        if (!!SlotsFilter)
            result.InsertValue("slots_filter", SlotsFilter->Serialize());
        return result;
    }

    void TDeployAction::DoDeserializeFromJson(const NJson::TJsonValue& json) {
        NJson::TJsonValue::TMapType map;
        CHECK_WITH_LOG(json.GetMap(&map));
        Service = map["service"].GetStringRobust();
        ServiceType = map["service_type"].GetStringRobust();
        CType = map["ctype"].GetStringRobust();
        Version = map["version"].GetStringRobust();
        MayBeDeadInIntervalPercentage = map["may_be_dead_percentage"].GetDoubleRobust();
        ForceServices = map["force_services"].GetStringRobust();
        DiffSlotsOnly = map["diff_slots_only"].GetBooleanRobust();
        NJson::TJsonValue::TMapType::const_iterator i = map.find("slots_filter");
        if (i != map.end()) {
            SlotsFilter.Reset(new NSearchMapParser::TSlotsPool);
            SlotsFilter->DeserializeFromJson(i->second);
        } else {
            SlotsFilter.Reset(nullptr);
        }
    }

    TDeployAction::TFactory::TRegistrator<TDeployAction> TDeployAction::Registrator(DEPLOY_ACTION_NAME);
}
