#pragma once
#include <saas/deploy_manager/scripts/common/script.h>
#include <saas/deploy_manager/server/client/client.h>

namespace NRTYDeploy {

    class TDeployBlockMaker {
    public:
        TDeployBlockMaker(const TString& service, const TString& ctype, IDeployInfoRequest& request);
        bool GetState(NJson::TJsonValue& conf, bool& blocked) const;
        bool IsBlocked() const;
        bool SetBlocked(const NJson::TJsonValue& jsConf);
        bool Remove();
    private:
        TString Service;
        TString CType;
        TString StoragePath;
        IDeployInfoRequest& Request;
    };

    class TScriptDeployBlock: public IScript {
    public:
        static TFactory::TRegistrator<TScriptDeployBlock> Registrator;
        virtual bool Process(IDeployInfoRequest& request);
    };
}
