#include "deploy_ping.h"

namespace NRTYDeploy {

    TScriptDeployPing::TScriptDeployPing() : TScriptBroadcast() {
        NeedStatus = false;
    }

    void TScriptDeployPing::DoPrepareJsonForReply(const TBroadcastSlotData& /*slot*/, NJson::TJsonValue& reply) {
        NJson::TJsonValue::TMapType map;
        if (reply.GetMap(&map)) {
            NJson::TJsonValue::TMapType::const_iterator i = map.find("status");
            if (i == map.end()) {
                reply = "Incorrect reply format";
            }
            else {
                reply = i->second;
            }
        }
        else {
            reply = "Incorrect reply format";
        }
    }

    bool TScriptDeployPing::Process(IDeployInfoRequest& request) {
        Command = "command=get_status";
        return TScriptBroadcast::Process(request);
    }

    IScript::TFactory::TRegistrator<TScriptDeployPing> TScriptDeployPing::Registrator("deploy_ping");
}
