#pragma once
#include <saas/deploy_manager/scripts/cluster/cluster_task.h>
#include <saas/deploy_manager/scripts/common/scripts_helper.h>
#include <saas/library/searchmap/slots_pool.h>


#define DEPLOY_TASK_TYPE "DEPLOY_TASK"

namespace NRTYDeploy {
    struct TIntervalDeployInfo {
        ui32 Count;
        TVector<NSearchMapParser::TSearchMapHost> Hosts;
        TIntervalDeployInfo() {
            Count = 0;
        }
    };

    typedef TMap<TInterval<NSearchMapParser::TShardIndex>, TIntervalDeployInfo> TInfoByInterval;

    class TDeployTask : public TClusterTask {
    private:
        TString Version;
        float MayBeDeadInIntervalPercentage;
        TAtomicSharedPtr<NSearchMapParser::TSlotsPool> SlotsFilter;
        TSet<TString> ForceServices;
        bool DiffSlotsOnly = false;
    private:
        void BuildDeployScriptReplica(const TVector<NSearchMapParser::TSearchMapHost>& hosts, const TNodesStructure& nodes, NRTYScript::TRTYClusterScript::TPtr& script, TDuration stopTimeout, NRTYScript::TSlotTaskContainer& setConfContainer);
        NRTYScript::TSlotTaskContainer BuildChainForDeploy(NRTYScript::TRTYClusterScript::TPtr& script, const TNodesStructure& nodes, const TVector<NSearchMapParser::TSearchMapHost>& hosts, TDuration stopTimeout, const NRTYScript::TSlotTaskContainer& startNode);
        void BuildAlertsTasks();
        NDaemonController::TAction::TPtr BuildScriptExecute(const NSearchMapParser::TSearchMapHost& info, const TNodesStructure& nodes) const;

    public:

        TDeployTask(const TClusterTask::TCgiContext& context, TString version, NRTYDeploy::ICommonData* commonData,
            float mayBeDeadInIntervalPercentage, TAtomicSharedPtr<NSearchMapParser::TSlotsPool> slotsFilter, const TString& forceServices,
            bool diffSlotsOnly);

        virtual void DoBuildTask();
    };

}
