#include "get_ctypes.h"
#include <saas/deploy_manager/modules/resources/resources.h>
#include <saas/deploy_manager/server/client/client.h>
#include <library/cpp/json/json_writer.h>
#include <util/string/cast.h>

namespace NRTYDeploy {
    bool TScriptCTypes::Process(IDeployInfoRequest& request) {
        try {
            const TVector<TString>& ctypes = request.GetResourcesManager().GetCTypes();

            NJson::TJsonValue json(NJson::JSON_ARRAY);
            const bool plain = request.GetRD().CgiParam.Has("plain_format") && FromString<bool>(request.GetRD().CgiParam.Get("plain_format"));
            for (const auto& i : ctypes) {
                if (plain)
                    json.AppendValue(NJson::JSON_MAP).InsertValue("id", i);
                else
                    json.AppendValue(i);
            }

            request.Output() << "HTTP/1.1 200 \r\n\r\n";
            request.Output() << NJson::WriteJson(&json);
            return false;
        }
        catch (...) {
            request.Output() << "HTTP/1.1 500 \r\n\r\n";
            request.Output() << CurrentExceptionMessage();
        }

        return true;
    }

    IScript::TFactory::TRegistrator<TScriptCTypes> TScriptCTypes::Registrator("ctypes");
}
