#pragma once

#include <saas/deploy_manager/scripts/common/script.h>

namespace NRTYDeploy {
    class TScriptGetFiles : public IScript {
    public:
        static TFactory::TRegistrator<TScriptGetFiles> Registrator;

        virtual bool Process(IDeployInfoRequest& request) override;

    private:
        struct TFileVersionInfo {
            ui32 Count = 0;
            ui32 Color = 0;
        };
        typedef THashMap<TString, TFileVersionInfo> TFileInfo;
        typedef TMap<TString, TFileInfo> TFiles;
        typedef THashMap<TString, NJson::TJsonValue> TTagsCache;

    private:
        void GetTagsInfoByServiceName(
            const TString& ctype,
            const TString& serviceType,
            const TString& serviceName,
            NJson::TJsonValue& tagsInfo,
            TFiles& filesVersionsCounts,
            IDeployInfoRequest& request
        );

        void SetColors(NJson::TJsonValue& service, TFiles& filesVersionsCounts);

    private:
        TRWMutex TagsCacheLock;
        TTagsCache TagsCache;
    };
};

