#pragma once

#include <saas/deploy_manager/scripts/interface/interface.pb.h>
#include <saas/deploy_manager/storage/abstract.h>
#include <library/cpp/object_factory/object_factory.h>

namespace NRTYDeploy {

    class TConfigTabWorker {
    public:
        virtual ~TConfigTabWorker() {}
        static void FillTab(NDMInterface::TConfigTab::TType tabType, NDMInterface::TConfigTab& tab, IVersionedStorage& storage, const NDMInterface::TProjectConfig::TComponent* component, const NDMInterface::TProjectConfig& projectConfig);
        static void SetChangedConfig(const NDMInterface::TConfigTab& tab, IVersionedStorage& storage);
        typedef NObjectFactory::TObjectFactory<TConfigTabWorker, NDMInterface::TConfigTab::TType> TFactory;

    protected:
        virtual void FillTabImpl(NDMInterface::TConfigTab& tab, IVersionedStorage& storage, const NDMInterface::TProjectConfig::TComponent* component, const NDMInterface::TProjectConfig& projectConfig) const = 0;
        virtual void SetChangedConfigImpl(const NDMInterface::TConfigTab& tab, IVersionedStorage& storage) = 0;
        static void SetFieldName(NDMInterface::TConfigField& field, const TString& name);
        static void SetFieldValue(NDMInterface::TConfigField& field, const TString& value);
    };
}
