#pragma once

#include "interface_script.h"

#include <saas/library/searchmap/searchmap.h>

namespace NRTYDeploy {

    using TCTypeMaps = TVector<std::pair<TString, NSearchMapParser::TSearchMap>>;

    class TScriptDashboard : public TScriptInterface {
    public:
        static TFactory::TRegistrator<TScriptDashboard> Registrator;
        virtual void DoProcess(IDeployInfoRequest& request) override;
    };

    TCTypeMaps DoBuildSearchMap(const IDeployInfoRequest& request, const NRTYDeploy::TClusterTask::TCgiContext& cgi,
        const THashSet<TString>& slotsFilters);

    // returns
    // - serialized search map
    // - flag which equals true if there are multiple maps
    // - request timeout
    std::tuple<TString, bool, TDuration> SerializeSearchMap(const TCTypeMaps& ctypeMaps);

};
