#pragma once

#include "grouping_common_param.h"
#include "sort.h"
#include <library/cpp/cgiparam/cgiparam.h>
#include <util/string/vector.h>

namespace NPrivate {
    class TGroupReporter {
    public:
        TGroupReporter(const TCgiParameters& cgi);
        bool Report(NJson::TJsonValue& result, const NJson::TJsonValue& richedData) const;
        void UpdateFieldsFilter(TSet<TString>& filter) const;
        TVector<TString> GetGroupings() const;

    private:
        struct TGrouping {
            TGrouping();
            explicit TGrouping(const TString& str);
            TString Filter;
            TString Name;
            bool OnlyParams;
            typedef TMap<TString, TGroupingCommonParam::TPtr> TCommonParams;
            TCommonParams CommonParams;
            TSort::TFullSort Sort;
        };

        typedef TVector<TGrouping> TGroupings;

        bool Report(NJson::TJsonValue& result, const NJson::TJsonValue& richedData, TGroupings::const_iterator group) const;
        TGroupings Groupings;
        bool FlatReport;
    };
}
