#pragma once

#include <util/generic/string.h>
#include <util/generic/ptr.h>
#include <util/generic/set.h>
#include <library/cpp/json/json_value.h>
#include <library/cpp/object_factory/object_factory.h>

namespace NPrivate {

    class TGroupingCommonParam : public TAtomicRefCount <TGroupingCommonParam> {
    public:
        typedef TIntrusivePtr<TGroupingCommonParam> TPtr;
        typedef NObjectFactory::TParametrizedObjectFactory<TGroupingCommonParam, TString, TString> TFactory;
        TGroupingCommonParam(const TString& expresion);
        virtual ~TGroupingCommonParam() {}
        bool UpdateParamValueFromElement(NJson::TJsonValue& paramValue, const NJson::TJsonValue& element) const;
        virtual void InsertParamValueToGroup(NJson::TJsonValue& group, const NJson::TJsonValue& paramValue) const;
        static TPtr Create(const TString& str);
        const TString& GetName() const {
            return Name;
        }
        const TSet<TString>& GetParams() const {
            return Params;
        }
    protected:
        virtual bool DoUpdateParamValue(NJson::TJsonValue& paramValue, const NJson::TJsonValue& calculatedValue) const = 0;
    private:
        TString Name;
        TSet<TString> Params;
    };
}
