#pragma once

#include "plainer.h"
#include <util/string/vector.h>
#include <util/generic/set.h>
#include <util/datetime/base.h>

namespace NPrivate {
    class TGroupInserter : public TPlainer::IInserter {
    public:
        TGroupInserter(NJson::TJsonValue& report,
                       const TVector<TString> groupings,
                       bool onlyProblem,
                       const NJson::TJsonValue& getInfoActionResult,
                       const NJson::TJsonValue& checkConfigResult,
                       TDuration minOkUptime);
        virtual NJson::TJsonValue* Insert(const NJson::TJsonValue& source) override;

    private:
        void InsertValuePlain(NJson::TJsonValue& result, const TString& key, const NJson::TJsonValue& value);
        bool SlotIsAccepted(const NJson::TJsonValue& slot, const NJson::TJsonValue* checkConfigResult);
        NJson::TJsonValue& Report;
        const TVector<TString> Groupings;
        bool OnlyProblem;
        TSet<TString> AcceptedHosts;
        TDuration MinOkUptime;
    };
}
