#include "interface_script.h"
#include <library/cpp/http/misc/httpcodes.h>

namespace NRTYDeploy {

    TScriptInterface::TScriptInterface()
        : User("guest")
        , Code(200)
    {}

    bool TScriptInterface::Process(IDeployInfoRequest& request) {
        TVector<TString> cookies = SplitString(TString{request.GetRD().HeaderInOrEmpty("Cookie")}, "; ");
        for (const auto& cookie : cookies) {
            TVector<TString> kv = SplitString(cookie, "=", 2);
            if (kv.size() > 0 && kv[0] == "yandex_login") {
                if (kv.size() > 1) {
                    User.Login = kv[1];
                }
                break;
            }
        }
        DoProcess(request);
        request.Output() << "HTTP/1.1 " << HttpCodeStrEx(Code) << " \r\n";
        request.Output() << "Content-Type:application/json; charset=utf-8\r\n";
        request.Output() << "\r\n";
        request.Output() << Report.GetStringRobust();
        return true;
    }

}
