#pragma once

#include <saas/deploy_manager/scripts/common/script.h>
#include <saas/deploy_manager/server/client/client.h>
#include <library/cpp/json/json_value.h>

namespace NRTYDeploy {

    class TScriptInterface : public IScript {
    public:
        TScriptInterface();
        virtual bool Process(IDeployInfoRequest& request);

        struct TUser {
            TUser(const TString& login)
                : Login(login)
            {}

            TString Login;
        };
    protected:
        virtual void DoProcess(IDeployInfoRequest& request) = 0;
        NJson::TJsonValue Report;
        TUser User;
        int Code;
    };

}
