#pragma once

#include <saas/deploy_manager/scripts/interface/interface.pb.h>
#include <saas/deploy_manager/storage/abstract.h>
#include <library/cpp/json/json_value.h>

namespace NRTYDeploy {
    NDMInterface::TProject GetProject(IVersionedStorage& storage, const TString& name);
    TString GetConfigDir(const NDMInterface::TProject::TComponent& comp);
    void Proto2Json(const google::protobuf::Message& proto, NJson::TJsonValue& json, bool skipMissing = false);
    void Json2Proto(const NJson::TJsonValue& json, google::protobuf::Message& proto);
    void CreateProjectConfig(NDMInterface::TProjectConfig& result, IVersionedStorage& storage, const TString& project);
    void SaveConfigVersion(const TString& projectName, IVersionedStorage& storage, NJson::TJsonValue* report);
}
