#pragma once

#include <saas/deploy_manager/scripts/interface/interface.pb.h>
#include <saas/deploy_manager/storage/abstract.h>
#include <util/generic/map.h>

namespace NRTYDeploy {
    void ListMatrixNetMetadata(TVector<NDMInterface::TRelevConfig::TMatrixNet>& result, IVersionedStorage& storage, const TString& path);
    void FillMatrixNetMetadata(NDMInterface::TRelevConfig::TMatrixNet& result, IVersionedStorage& storage, const TString& path, i64 version);
    void DecodePolynom(NDMInterface::TRelevConfig::TPolynom& result, const TString& polynom);
    TString EncodePolynom(const NDMInterface::TRelevConfig::TPolynom& polynom);
    TString EncodePolynom(const TString& polynom, const TMap<TString, ui32>& namesToIndex);
    TString DecodePolynom(const TString& encodedPolynom, const TMap<ui32, TString>& indexesToNames);
}
