#pragma once

#include <saas/deploy_manager/scripts/interface/interface.pb.h>
#include "interface_script.h"

class TAnketaProcessor {
public:
    typedef NDMInterface::TServiceWizardReply::TError TError;

    TAnketaProcessor(IDeployInfoRequest& request, const NRTYDeploy::TScriptInterface::TUser& user);

    const NDMInterface::TServiceWizardReply& GetReply() const;

    void Process();
    const static TString SERVICE_NAME_NAME;

private:
    void Error(TError::TLevel level, const TString& message, bool stopProcess = false);
    void AddFile(const TString& name, const TString& content);
    void AddFile(const TString& name, const NJson::TJsonValue& content);
    void PrintYConfigLevel(IOutputStream& out, const TString& name, const NJson::TJsonValue& content, ui32 level);
    void AddYConfigFile(const TString& name, const NJson::TJsonValue& content);
    void AddFile(const TString& name, const google::protobuf::Message& content);
    NDMInterface::TProject::TRequestExample::TParam& AddRequestParam(const TString& name);
    NDMInterface::TProject::TRequestExample::TParam& AddRequestParam(const TString& name, bool optional);
    TSet<TString> GetCheckListValues(const TString& name) const;
    NJson::TJsonValue& SearchProxyConfig(const TString& service);

    void DoProcess();
    void SetupUser();
    void FillProjectComponent(const TString& name, const TString& type, bool main);
    void SetupProject();
    void SetupServiceMeta();
    NJson::TJsonValue SetupParser(const TString& ml);
    void SetupHtmlParser(const TString& service);
    void SetupXmlParser(const TString& service);
    void SetupZoneToProperies();
    void SetupQueryLanguage();
    void SetupQueryLanguageEntity(const TString& question, const TString& prefix, const TString& option, THashSet<TString>& setToSave);
    void SetupSnippetDeniedZones();
    void SetupGroupAttrs();
    void SetupProperties();
    void SetupFacets();
    void SetupLanguages();
    void SetupRelev();
    void SetupServiceCommon(const TString& service);
    void SetupServiceSearch();
    void SetupServiceKeyValue();
    void SetupServiceSuggest();
    void SetupCgiParams();

private:

    struct TQuestionData {
        TQuestionData();
        TQuestionData(const TString& page, const NDMInterface::TServiceWizardQuestion& data);

        TString Page;
        const NDMInterface::TServiceWizardQuestion* Data;
    };

    typedef THashMap<TString, TQuestionData> TQById;
    typedef THashMap<TString, NDMInterface::TProject::TRequestExample::TParam> TParamsById;

    NDMInterface::TServiceWizardReply Reply;
    NDMInterface::TServiceWizard Questions;
    TQById QById;
    TParamsById ParamsById;
    NJson::TJsonValue Anketa;
    NJson::TJsonValue JsonFiles;
    NJson::TJsonValue YConfigFiles;
    TString Project;
    TString SearchService;
    TString SuggestService;
    TString MetaService;
    NRTYDeploy::IVersionedStorage& Storage;
    const NRTYDeploy::TScriptInterface::TUser& User;
    THashMap<TString, THashMap<TString, TString> > CgiParamsByService;
    THashSet<TString> SearchLiteralAttrs;
    THashSet<TString> SearchIntegerAttrs;
    THashSet<TString> SearchZones;
    THolder<NJson::TJsonValue> XmlParserConfig;
    THolder<NJson::TJsonValue> HtmlParserConfig;
};
