#include "service_wizard_script.h"
#include "service_wizard_anketa_processor.h"
#include "projects_utils.h"
#include "users_utils.h"

#include <util/string/type.h>

template <class TMessage>
bool NRTYDeploy::TScroptServiceWizard::ProcessMessageAccept(IDeployInfoRequest& request, const TString& name) {
    const TCgiParameters& cgi = request.GetRD().CgiParam;
    TString action = cgi.Get("action");
    if (action == "get_" + name) {
        TMessage message;
        request.GetStorage().GetValue("service_wizard/" + name, message);
        Proto2Json(message, Report, true);
    } else if (action == "set_" + name) {
        TMessage message;
        TMemoryInput is(request.GetBlob().AsCharPtr(), request.GetBlob().Size());
        NJson::TJsonValue json;
        NJson::ReadJsonTree(&is, &json, true);
        Json2Proto(json, message);
        request.GetStorage().SetValue("service_wizard/" + name, message, false);
        Proto2Json(message, Report, true);
    } else
        return false;
    return true;
}

void NRTYDeploy::TScroptServiceWizard::DoProcess(IDeployInfoRequest& request) {
    const TCgiParameters& cgi = request.GetRD().CgiParam;
    TString action = cgi.Get("action");
    if (action == "get_questions") {
        NDMInterface::TServiceWizard message;
        request.GetStorage().GetValue("service_wizard/questions", message);
        TString project = cgi.Get("project");
        TString anketaData;
        NJson::TJsonValue anketa;
        if (!!project) {
            if (request.GetStorage().GetValue("/projects/" + project + "/anketa", anketaData)) {
                TStringInput si(anketaData);
                NJson::ReadJsonTree(&si, &anketa);
            }
            for (auto& page : *message.MutablePages()) {
                for (auto& question : *page.MutableQuestions()) {
                    const TString& qId = question.GetCommon().GetId();
                    if (anketa.Has(qId))
                        question.SetValue(anketa[qId].GetStringRobust());
                    if (qId == TAnketaProcessor::SERVICE_NAME_NAME)
                        question.SetValue(project);
                }
            }
        }
        Proto2Json(message, Report, true);
    } else if (ProcessMessageAccept<NDMInterface::TServiceWizard>(request, "questions")) {
    } else if (ProcessMessageAccept<NDMInterface::TProject::TRequestExample>(request, "request_params")) {
    } else if (action == "send_anketa") {
        TAnketaProcessor processor(request, User);
        processor.Process();
        if ((!cgi.Has("check_only") || IsFalse(cgi.Get("check_only"))) && processor.GetReply().GetOk()) {
            for (const auto& file : processor.GetReply().GetFiles()) {
                if (!request.GetStorage().SetValue(file.GetName(), file.GetContent()))
                    ythrow TCodedException(500) << "Cannot write content to " << file.GetName();
            }
            Proto2Json(processor.GetReply().GetProject(), Report, true);
        } else
            Proto2Json(processor.GetReply(), Report, true);
        if (!processor.GetReply().GetOk())
            Code = 400;
    }
    else
        ythrow TCodedException(400) << "unknown action: " << action;
}

NRTYDeploy::TScroptServiceWizard::TFactory::TRegistrator<NRTYDeploy::TScroptServiceWizard> NRTYDeploy::TScroptServiceWizard::Registrator("service_wizard");
