#pragma once

#include <saas/deploy_manager/scripts/interface/interface.pb.h>
#include <saas/deploy_manager/storage/abstract.h>
#include <library/cpp/json/json_value.h>

namespace NRTYDeploy {
    NDMInterface::TUser GetUser(IVersionedStorage& storage, const TString& login);
    void ListUsers(IVersionedStorage& storage, TVector<TString>& result);
    NDMInterface::TUser::TRole GetUserRoleInProject(IVersionedStorage& storage, const TString& login, const TString& project);
    void FillProjectUsers(IVersionedStorage& storage, NDMInterface::TProject& project);
    void SaveUser(IVersionedStorage& storage, const NDMInterface::TUser& user);
}
