#include "action.h"

#include <library/cpp/json/writer/json_value.h>
#include <library/cpp/json/json_reader.h>
#include <library/cpp/logger/global/global.h>
#include <util/stream/str.h>

namespace NDaemonController {
    NJson::TJsonValue TLockerAction::DoSerializeToJson() const {
        NJson::TJsonValue result;
        result.InsertValue("lock_name", LockName);
        result.InsertValue("action", Action);
        result.InsertValue("lock_info", LockInfo);
        return result;
    }

    void TLockerAction::DoDeserializeFromJson(const NJson::TJsonValue& json) {
        NJson::TJsonValue::TMapType map;
        CHECK_WITH_LOG(json.GetMap(&map));
        LockName = map["lock_name"].GetStringRobust();
        Action = map["action"].GetStringRobust();
        LockInfo = map["lock_info"].GetStringRobust();
    }

    void TLockerAction::DoInterpretResult(const TString& result) {
        Success(result);
    }

    TLockerAction::TFactory::TRegistrator<TLockerAction> TLockerAction::Registrator(LOCKER_ACTION_NAME);
}
