#pragma once
#include <saas/library/daemon_base/actions_engine/controller_client.h>
#include <util/string/vector.h>

#define LOCKER_ACTION_NAME "LOCKER"

namespace NDaemonController {

    class TLockerAction : public TAction {
    private:
        TString LockName;
        TString Action;
        TString LockInfo;
    protected:

        virtual NJson::TJsonValue DoSerializeToJson() const;
        virtual void DoDeserializeFromJson(const NJson::TJsonValue& json);

        virtual ui32 GetAttemptionsMaxResend() const {
            return Max<ui32>();
        }

        virtual TString GetCustomUri() const {
            return "locker";
        }

        virtual TString DoBuildCommand() const {
            return "lock_name=" + LockName + "&action=" + Action + "&lock_info=" + LockInfo;
        }

        virtual void DoInterpretResult(const TString& result);

        static TFactory::TRegistrator<TLockerAction> Registrator;
    public:

        TLockerAction() {}

        TLockerAction(const TString& lockName, const TString& action, const TString& lockInfo)
            : LockName(lockName)
            , Action(action)
            , LockInfo(lockInfo)
        {}

        virtual TString ActionName() const { return LOCKER_ACTION_NAME; }
    };
}
