#pragma once

#include <saas/library/daemon_base/actions_engine/controller_client.h>
#include <library/cpp/json/writer/json_value.h>

#define LOGIC_ACTION_NAME "LOGIC_ACTION"

namespace NRTYDeploy {

    class TLogicAction: public NDaemonController::TAction {
    protected:

        virtual TString ActionName() const override {
            return LOGIC_ACTION_NAME;
        }

        virtual bool IsLogicAction() const override {
            return true;
        }

        virtual TString GetCustomUri() const override {
            return "";
        }

        virtual NJson::TJsonValue DoSerializeToJson() const override;
        virtual void DoDeserializeFromJson(const NJson::TJsonValue& json) override;

        static TFactory::TRegistrator<TLogicAction> Registrator;
    public:

        TLogicAction() {
            Status = TAction::asSuccess;
        }

        virtual void DoInterpretResult(const TString& /*result*/) override {
            CHECK_WITH_LOG(IsFinished());

        }

        virtual void AddPrevActionsResult(const NRTYScript::ITasksInfo& /*info*/) override {
        }

        virtual TString DoBuildCommand() const override {
            FAIL_LOG("Can't use this method");
            return "";
        }
    };
}
