#pragma once
#include <saas/deploy_manager/server/client/client.h>

NJson::TJsonValue GetAlertKeys(const IDeployInfoRequest& request);
bool GetAlertsServiceOptions(const TString& service, const TString& ctype, const IDeployInfoRequest& request,
    NJson::TJsonValue& result, NJson::TJsonValue& aKeys, NJson::TJsonValue& resultParts);

class TAlertsOptions {
private:
    TSimpleSharedPtr<const NJson::TJsonValue> AKeys;
    TSimpleSharedPtr<const NJson::TJsonValue> AlertsConf;
public:
    TAlertsOptions(const TSimpleSharedPtr<NJson::TJsonValue>& aKeys, const TSimpleSharedPtr<NJson::TJsonValue>& alertsConf);
    TSet<TString> GetAKeys(const bool isMetaService) const;
    TString GetIType(const TString& aKey) const;
    bool GetWithPrj(const TString& aKey) const;
    bool GetWithTier(const TString& aKey) const;
    bool GetIsUsers(const TString& aKey) const;
    bool GetMustCall(const TString& aKey) const;
    bool IsNotifyDisabled(const TString& aKey) const;
    bool IsAllNotifyDisabled() const;
    bool GetFlaps(const TString& aKey, ui32& critical, ui32& stable, ui32& boost) const;
    bool GetNotificationTimes(const TString& aKey, TString& timeStart, TString& timeEnd) const;
    bool GetOwners(const bool isUsers, TVector<TString>& result) const;
    bool GetOwners(const TString& aKey, TVector<TString>& result) const;
    TString GetSignalTempl(const TString& aKey) const;
    bool GetLimits(const TString& aKey, double& warn, double& crit, ui16& avgsec) const;
};
