#pragma once

#include "alerts_config.h"

#include <saas/deploy_manager/modules/juggler/module.h>
#include <saas/deploy_manager/modules/golovan/format.h>
#include <saas/deploy_manager/server/client/client.h>

TString GolovanId(const TString& service, const TString& ctype, const TString& aKey,
    const TString& itype, const TString& prefix, const TString& dcpart="");

bool VerifyCtypeService(const TString& service, const TString& ctype, const IDeployInfoRequest& request,
    bool& isMeta, TString& errorMessage);

bool GetCtypesServices(const IDeployInfoRequest& request, NJson::TJsonValue& result, const TString& ctypesPrefix="");

bool ClearNotExistingServices(const IDeployInfoRequest& request, NJson::TJsonValue& result, bool dry=false);

class TAlertsMaker {
private:
    const TString Service;
    const TString Ctype;
    const TString GolovanPrefix;
    bool IsMetaService;
    IDeployInfoRequest& Request;
    TAlertsOptions Options;
    bool Valid;
    TString ErrorMessage;
public:
    TAlertsMaker(const TString& service, const TString& ctype, IDeployInfoRequest& request);
    const TAlertsOptions& GetOptions() const;
    bool IsValid() const {
        return Valid;
    }
    const TString& GetErrorMessage() const {
        return ErrorMessage;
    }
    bool FillJugglerCheck(const TString& aKey, TJugglerCheck& jCheck, const TVector<TString>& owners);
    bool CreateJugglerCheck(const TString& aKey, NJson::TJsonValue& result, bool dryRun=false);

    bool GetExceedingMissingKeys(NJson::TJsonValue& result, NJson::TJsonValue& checks, NJson::TJsonValue& alerts);
    bool CompareSingleAlert(const TString& aKey, const TExistingAlert& exAlert, NJson::TJsonValue& result);
    bool CompareSingleCheck(const TString& aKey, const TExistingCheck& exCheck, bool needOwnersCheck, NJson::TJsonValue& result);
    bool GetUnactualDataChecks(const TSet<TString>& akeys, const NJson::TJsonValue& checks, NJson::TJsonValue& result);
    bool GetUnactualDataAlerts(const TSet<TString>& aKeys, const NJson::TJsonValue& alerts, NJson::TJsonValue& result);
    bool GetFullServiceActuality(NJson::TJsonValue& result);

    bool ActualizeExceedingMissingKeys(const NJson::TJsonValue& lists, NJson::TJsonValue& result);
    bool ActualizeChecks(const NJson::TJsonValue& cDiff, NJson::TJsonValue& result);
    bool ActualizeAlerts(const NJson::TJsonValue& aDiff, NJson::TJsonValue& result);

    bool ActualizeFullService(bool existingOnly, NJson::TJsonValue& result, bool dryRun=false);

    TYasmAlert GenerateYasmAlert(const TString& aKey, bool& success);
    bool CreateYasmAlert(const TString& aKey, NJson::TJsonValue& result);
    TString GetSignal(const TString& aKey) const;
    bool ComputePrjTag(TString& prj) const;
};
