#pragma once

#include <saas/library/daemon_base/actions_engine/controller_client.h>
#include <library/cpp/json/writer/json_value.h>

using namespace NDaemonController;

#define ALERTS_CLEAR_ACTION_NAME "ALERTS_CLEAR_LEFT_ACTION"

namespace NRTYDeploy {

    class TAlertsClearAction : public TAction {
    private:
    protected:

        virtual NJson::TJsonValue DoSerializeToJson() const override;
        virtual void DoDeserializeFromJson(const NJson::TJsonValue& json) override;

        static TFactory::TRegistrator<TAlertsClearAction> Registrator;

    public:

        TAlertsClearAction() {};

        virtual TString GetCustomUri() const override {
            return "process_alerts";
        }

        virtual TString DoBuildCommand() const override {
            return  "action=clear_left";
        }

        virtual TString ActionName() const override {
            return ALERTS_CLEAR_ACTION_NAME;
        }

        virtual void DoInterpretResult(const TString& result) override;
    };
}
