
#include "alerts_service_action.h"

namespace NRTYDeploy {

    NJson::TJsonValue TAlertsServiceAction::DoSerializeToJson() const {
        NJson::TJsonValue result(NJson::JSON_MAP);
        result.InsertValue("service", Service);
        result.InsertValue("ctype", CType);
        return result;
    }

    void TAlertsServiceAction::DoDeserializeFromJson(const NJson::TJsonValue& json) {
        CHECK_WITH_LOG(json.IsMap());
        Service = json["service"].GetStringRobust();
        CType = json["ctype"].GetStringRobust();
    }

    void TAlertsServiceAction::DoInterpretResult(const TString& result) {
        Success(result);
    }

}
