#pragma once

#include <saas/library/daemon_base/actions_engine/controller_client.h>
#include <library/cpp/json/writer/json_value.h>

using namespace NDaemonController;

namespace NRTYDeploy {

    class TAlertsServiceAction : public TAction {
    private:
        TString Service;
        TString CType;

    protected:

        virtual NJson::TJsonValue DoSerializeToJson() const override;
        virtual void DoDeserializeFromJson(const NJson::TJsonValue& json) override;

        virtual TString GetProcessAlertsAction() const = 0;

    public:

        TAlertsServiceAction() {}

        TAlertsServiceAction(const TString& service, const TString& ctype)
            : Service(service)
            , CType(ctype)
        {};

        virtual TString GetCustomUri() const override {
            return "process_alerts";
        }

        virtual TString DoBuildCommand() const override {
            return "service=" + Service +
                "&ctype=" + CType +
                "&action=" + GetProcessAlertsAction();
        }

        TString ActionName() const override = 0;

        virtual void DoInterpretResult(const TString& result) override;
    };
}
