#include "ctype_action.h"

namespace NRTYDeploy {
    NJson::TJsonValue TAlertsCtypeAction::DoSerializeToJson() const {
        NJson::TJsonValue result;
        result.InsertValue("ctype", CType);
        return result;
    }

    void TAlertsCtypeAction::DoDeserializeFromJson(const NJson::TJsonValue& json) {
        CHECK_WITH_LOG(json.IsMap());
        CType = json["ctype"].GetStringRobust();
    }

    TAlertsCtypeAction::TFactory::TRegistrator<TAlertsCtypeAction> TAlertsCtypeAction::Registrator(ALERTS_CTYPE_ACTION_NAME);
}
