#pragma once
#include <saas/deploy_manager/scripts/cluster/cluster_task.h>
#include <library/cpp/json/writer/json_value.h>
#include <util/string/vector.h>

#define ALERTS_CTYPE_ACTION_NAME "ALERTS_CTYPE_ACTION"

namespace NRTYDeploy {

    class TAlertsCtypeAction : public NRTYDeploy::TClusterAsyncAction {
    private:
        TString CType;
    protected:

        virtual NJson::TJsonValue DoSerializeToJson() const override;
        virtual void DoDeserializeFromJson(const NJson::TJsonValue& json) override;

        virtual TString GetCustomUriStart() const override {
            return "total_alerts";
        }

        virtual TString DoBuildCommandStart() const override {
            return "ctype=" + CType;
        }

        static TFactory::TRegistrator<TAlertsCtypeAction> Registrator;
    public:

        TAlertsCtypeAction() {}

        TAlertsCtypeAction(const TString& waitActionName)
            : TClusterAsyncAction(waitActionName)
        {}

        TAlertsCtypeAction(TString cType, NDaemonController::TAsyncPolicy policy)
            : TClusterAsyncAction(policy)
            , CType(cType)
        {
        }

        virtual TString ActionName() const override { return ALERTS_CTYPE_ACTION_NAME; }

    };
}
