#include "script.h"
#include "ctype_task.h"
#include "total_task.h"

#include <saas/deploy_manager/server/client/client.h>

namespace NRTYAlerts {

    TClusterTask::TPtr TScriptTotalAlerts::DoBuildTask(IDeployInfoRequest& request) const {
        bool alertsEnabled = request.GetCommonData().GetConfig().GetAlertsConfig().GetEnabled();
        if (!alertsEnabled) {
            request.Output() << "HTTP/1.1 400 \r\n\r\n";
            request.Output() << "Alerts disabled for this dm";
            return nullptr;
        }

        const TCgiParameters& cgi = request.GetRD().CgiParam;
        TClusterTask::TCgiContext context = TClusterTask::TCgiContext::Parse(cgi);

        context.Service = "alerts";
        if (!context.CType) {
            context.CType = "all";
            return new TAlertsTotalTask(context, &request);
        } else {
            return new TAlertsCTypeTask(context, &request);
        }
    }

    IScript::TFactory::TRegistrator<TScriptTotalAlerts> TScriptTotalAlerts::Registrator("total_alerts");
}
