#pragma once
#include <saas/deploy_manager/scripts/cluster/cluster_task.h>
#include <library/cpp/json/writer/json_value.h>
#include <util/string/vector.h>

#define ALERTS_TOTAL_ACTION_NAME "ALERTS_TOTAL_ACTION"

namespace NRTYDeploy {

    class TAlertsTotalAction : public NRTYDeploy::TClusterAsyncAction {
    private:
    protected:

        virtual NJson::TJsonValue DoSerializeToJson() const override;
        virtual void DoDeserializeFromJson(const NJson::TJsonValue& json) override;

        virtual TString GetCustomUriStart() const override {
            return "total_alerts";
        }

        virtual TString DoBuildCommandStart() const override {
            return "";
        }

        static TFactory::TRegistrator<TAlertsTotalAction> Registrator;
    public:

        TAlertsTotalAction() {}

        TAlertsTotalAction(const TString& waitActionName)
            : TClusterAsyncAction(waitActionName)
        {}

        TAlertsTotalAction(NDaemonController::TAsyncPolicy policy)
            : TClusterAsyncAction(policy)
        {
        }

        virtual TString ActionName() const override { return ALERTS_TOTAL_ACTION_NAME; }

    };
}
