#pragma once
#include <saas/library/daemon_base/actions_engine/controller_client.h>

#include <library/cpp/json/writer/json_value.h>

#define PROCESS_SLA_DESCRIPTION_ACTION_NAME "PROCESS_SLA_DESCRIPTION"

namespace NDaemonController {

    class TProcessSLADescriptionAction : public TAction {
    public:
        TProcessSLADescriptionAction() {
        }

        TProcessSLADescriptionAction(const TString& service, const TString& ctype);

        virtual TDuration GetTimeoutDuration() const override final;
        virtual bool GetPostContent(TString& result) const override final;
        virtual TString ActionName() const override final;

        TProcessSLADescriptionAction& SetOwners(const TSet<TString>& owners);
        TProcessSLADescriptionAction& SetResponsibles(const TSet<TString>& responsibles);
        TProcessSLADescriptionAction& SetTicket(const TString& ticket);
        TProcessSLADescriptionAction& SetMaxDocsPerService(ui64 maxDocs);
        TProcessSLADescriptionAction& SetSearchRPS(ui64 searchRPS);
        TProcessSLADescriptionAction& SetSearchRPSPlanned(ui64 searchRPSPlanned);
        TProcessSLADescriptionAction& SetIndexRPS(ui64 indexRPS);
        TProcessSLADescriptionAction& SetTotalIndexSizeBytes(ui64 totalIndexSizeBytes);
        TProcessSLADescriptionAction& SetSearchQ99Ms(ui64 searchQ99Ms);
        TProcessSLADescriptionAction& SetSearchQ999Ms(ui64 searchQ999Ms);
        TProcessSLADescriptionAction& SetUnanswers5MinPercWarn(double unanswers5MinPercWarn);
        TProcessSLADescriptionAction& SetUnanswers5MinPercCrit(double unanswers5MinPercCrit);
        TProcessSLADescriptionAction& SetServiceWeight(ui64 serviceWeight);
        TProcessSLADescriptionAction& SetABCUserService(ui64 abcUserService);
        TProcessSLADescriptionAction& SetABCQuotaService(ui64 abcQuotaService);
        TProcessSLADescriptionAction& SetDisasterAlerts(ui64 disasterAlerts);
        TProcessSLADescriptionAction& SetFerrymans(const TSet<TString>& ferrymans);
        TProcessSLADescriptionAction& SetPatch();
        TProcessSLADescriptionAction& SetUseDefault();


    protected:
        virtual NJson::TJsonValue DoSerializeToJson() const override final;
        virtual void DoDeserializeFromJson(const NJson::TJsonValue& json) override final;

        virtual TString GetCustomUri() const override final;
        virtual TString DoBuildCommand() const override final;
        virtual void DoInterpretResult(const TString& result) override final;

    private:
        TString Service;
        TString CType;
        bool IsPatch = false;
        bool UseDefault = false;

        TSet<TString> Owners;
        TSet<TString> Responsibles;
        TMaybe<TString> Ticket;
        TMaybe<ui64> MaxDocsMaybe;
        TMaybe<ui64> SearchRPSMaybe;
        TMaybe<ui64> SearchRPSPlannedMaybe;
        TMaybe<ui64> IndexRPSMaybe;
        TMaybe<ui64> TotalIndexSizeBytesMaybe;
        TMaybe<ui64> SearchQ99MsMaybe;
        TMaybe<ui64> SearchQ999MsMaybe;
        TMaybe<double> Unanswers5MinPercWarnMaybe;
        TMaybe<double> Unanswers5MinPercCritMaybe;
        TMaybe<ui64> ServiceWeightMaybe;
        TMaybe<ui64> ABCUserServiceMaybe;
        TMaybe<ui64> ABCQuotaServiceMaybe;
        TMaybe<ui64> DisasterAlertsMaybe;
        TSet<TString> Ferrymans;

        i64 Version = -1;
        TString MD5Hash;

        static TFactory::TRegistrator<TProcessSLADescriptionAction> Registrator;
    };
}
