#include "action.h"

#include <library/cpp/json/writer/json_value.h>
#include <library/cpp/json/json_reader.h>
#include <library/cpp/logger/global/global.h>
#include <util/stream/str.h>

namespace NDaemonController {
    NJson::TJsonValue TReleaseSlotsAction::DoSerializeToJson() const {
        NJson::TJsonValue result;
        result.InsertValue("slots", JoinStrings(Slots, ","));
        result.InsertValue("ctype", CType);
        result.InsertValue("service", Service);
        result.InsertValue("service_type", ServiceType);
        result.InsertValue("deploy", Deploy);
        result.InsertValue("deploy_proxies", DeployProxies);

        return result;
    }

    void TReleaseSlotsAction::DoDeserializeFromJson(const NJson::TJsonValue& json) {
        CHECK_WITH_LOG(json.IsMap());
        Slots = SplitString(json["slots"].GetStringRobust(), ",");
        CType = json["ctype"].GetStringRobust();
        Service = json["service"].GetStringRobust();
        ServiceType = json["service_type"].GetStringRobust();
        Deploy = json["deploy"].GetBoolean();
        DeployProxies = json["deploy_proxies"].GetBoolean();
    }

    TReleaseSlotsAction::TFactory::TRegistrator<TReleaseSlotsAction> TReleaseSlotsAction::Registrator(RELEASE_SLOTS_ACTION_NAME);
}
