#pragma once
#include <saas/deploy_manager/scripts/cluster/cluster_task.h>
#include <saas/library/daemon_base/actions_engine/controller_client.h>
#include <util/string/vector.h>

#define RELEASE_SLOTS_ACTION_NAME "RELEASE_SLOTS"

namespace NDaemonController {

    class TReleaseSlotsAction : public NRTYDeploy::TClusterAsyncAction {
    private:
        TVector<TString> Slots;
        TString CType;
        TString Service;
        TString ServiceType;
        bool Deploy;
        bool DeployProxies;
    protected:

        virtual NJson::TJsonValue DoSerializeToJson() const override;
        virtual void DoDeserializeFromJson(const NJson::TJsonValue& json) override;

        virtual TString GetCustomUriStart() const override {
            return "release_slots";
        }

        virtual TString DoBuildCommandStart() const override {
            return "slots=" + JoinStrings(Slots, ",") + "&ctype=" + CType + "&service=" + Service + "&service_type=" + ServiceType +
                "&deploy=" + ToString(Deploy) + "&deploy_proxies=" + ToString(DeployProxies);
        }

        static TFactory::TRegistrator<TReleaseSlotsAction> Registrator;
    public:

        TReleaseSlotsAction() {}

        TReleaseSlotsAction(const TVector<TString>& slots, const TString& ctype, const TString& service, const TString& serviceType, bool deploy, bool deployProxies)
            : TClusterAsyncAction(NDaemonController::apStartAndWait)
            , Slots(slots)
            , CType(ctype)
            , Service(service)
            , ServiceType(serviceType)
            , Deploy(deploy)
            , DeployProxies(deployProxies)
        {}

        virtual TString ActionName() const override { return RELEASE_SLOTS_ACTION_NAME; }
    };
}
