#include "script.h"
#include "task.h"
#include <saas/deploy_manager/server/client/client.h>
#include <saas/deploy_manager/scripts/common/scripts_helper.h>

#include <util/string/type.h>

namespace NRTYDeploy {

    TClusterTask::TPtr TScriptReleaseSlots::DoBuildTask(IDeployInfoRequest& request) const {
        const TCgiParameters& cgi = request.GetRD().CgiParam;

        TClusterTask::TCgiContext context = TClusterTask::TCgiContext::Parse(cgi);

        const bool deploy = IsTrue(cgi.Get("deploy"));
        const bool deployProxies = IsTrue(cgi.Get("deploy_proxies"));

        if (!context.Service) {
            request.Output() << "HTTP/1.1 400 \r\n\r\n";
            request.Output() << "service does not set";
            return nullptr;
        }

        if (!context.CType) {
            request.Output() << "HTTP/1.1 400 \r\n\r\n";
            request.Output() << "ctype does not set";
            return nullptr;
        }

        const TString& slots = cgi.Get("slots");
        if (!slots) {
            request.Output() << "HTTP/1.1 400 \r\n\r\n";
            request.Output() << "slots does not set";
            return nullptr;
        }

        const TVector<TString> slotsV = SplitString(slots, ",");

        return new TReleaseTask(slotsV, context, &request, deploy, deployProxies);
    }

    IScript::TFactory::TRegistrator<TScriptReleaseSlots> TScriptReleaseSlots::Registrator("release_slots");
}
