#include "action.h"

#include <library/cpp/json/json_reader.h>
#include <library/cpp/json/writer/json_value.h>
#include <library/cpp/logger/global/global.h>

#include <util/stream/str.h>

namespace NDaemonController {

    NJson::TJsonValue TReshardAction::DoSerializeToJson() const {
        NJson::TJsonValue result;
        result.InsertValue("shard_min", ShardMin);
        result.InsertValue("shard_max", ShardMax);
        result.InsertValue("new_parts_count", NewPartsCount);
        result.InsertValue("ctype", CType);
        result.InsertValue("service", Service);
        result.InsertValue("service_type", ServiceType);
        return result;
    }

    void TReshardAction::DoDeserializeFromJson(const NJson::TJsonValue& json) {
        CHECK_WITH_LOG(json.IsMap());
        ShardMin = json["shard_min"].GetIntegerRobust();
        ShardMax = json["shard_max"].GetIntegerRobust();
        NewPartsCount = json["new_parts_count"].GetIntegerRobust();
        CType = json["ctype"].GetStringRobust();
        Service = json["service"].GetStringRobust();
        ServiceType = json["service_type"].GetStringRobust();
    }

    TReshardAction::TFactory::TRegistrator<TReshardAction> TReshardAction::Registrator(RESHARD_ACTION_NAME);
}


